CREATE TABLE [dbo].[PostcodeEenvoudigImport](
	[ID] [INT] NOT NULL,
	[PostcodeNummers] [NVARCHAR](128) NULL,
	[PostcodeLetters] [NVARCHAR](128) NULL,
	[PostcodeVolledig] [NVARCHAR](128) NULL,
	[HuisnummerRangeStart] [NVARCHAR](128) NULL,
	[HuisnummerRangeEind] [NVARCHAR](128) NULL,
	[Straat] [NVARCHAR](128) NULL,
	[Plaats] [NVARCHAR](128) NULL,
	[Gemeente] [NVARCHAR](128) NULL,
	[Provincie] [NVARCHAR](128) NULL,
	[Latitude] [NVARCHAR](128) NULL,
	[Longitude] [NVARCHAR](128) NULL,
	[XCoordinaat] [NVARCHAR](128) NULL,
	[YCoordinaat] [NVARCHAR](128) NULL,
	[CreatieDatum] [DATETIME] NOT NULL,
 CONSTRAINT [PK_PostcodeEenvoudigImport] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

/****** Object:  Table [dbo].[PostcodeVolledigImport]    Script Date: 21-9-2017 10:18:50 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[PostcodeVolledigImport](
	[ID] [INT] NOT NULL,
	[PostcodeNummers] [INT] NULL,
	[PostcodeLetters] [NVARCHAR](128) NULL,
	[PostcodeVolledig] [NVARCHAR](128) NULL,
	[Huisnummer] [NVARCHAR](128) NULL,
	[HuisnummerLetter] [NVARCHAR](128) NULL,
	[HuisnummerToevoeging] [NVARCHAR](128) NULL,
	[Straat] [NVARCHAR](128) NULL,
	[Plaats] [NVARCHAR](128) NULL,
	[Gemeente] [NVARCHAR](128) NULL,
	[Provincie] [NVARCHAR](128) NULL,
	[Doel] [NVARCHAR](128) NULL,
	[Oppervlakte] [NVARCHAR](128) NULL,
	[VerblijfsStatus] [NVARCHAR](128) NULL,
	[PandStatus] [NVARCHAR](128) NULL,
	[BouwJaar] [NVARCHAR](128) NULL,
	[Latitude] [NVARCHAR](128) NULL,
	[Longitude] [NVARCHAR](128) NULL,
	[XCoordinaat] [NVARCHAR](128) NULL,
	[YCoordinaat] [NVARCHAR](128) NULL,
	[NevenVestiging] [NVARCHAR](128) NULL,
	[ObjectID] [NVARCHAR](128) NULL,
	[CreatieDatum] [DATETIME] NOT NULL,
 CONSTRAINT [PK_PostcodetabelTEST] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[PostcodeEenvoudigImport] ADD  CONSTRAINT [DF_PostcodeEenvoudigImport_MutatieDatum]  DEFAULT (GETDATE()) FOR [CreatieDatum]
GO

ALTER TABLE [dbo].[PostcodeVolledigImport] ADD  CONSTRAINT [DF_PostcodetabelTEST_MutatieDatum]  DEFAULT (GETDATE()) FOR [CreatieDatum]
GO


